<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

namespace StemBase\Modules\Shortcodes\Shortcode;

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}

use StemBase\Modules\Shortcodes\Shortcode\ShortcodeBase;

class Divider extends ShortcodeBase {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $name = "divider";
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $version = "1.0";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $help = "";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_usage = "[divider /]\n[divider resource=\"text\"]Sample divider[/divider]";

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_attributes = array(
		array(
			"name"		=> "style",
			"hint"		=> "solid|dotted|dashed|double_solid|double_dotted|double_dashed|none, default: solid"
		),
		array(
			"name"		=> "width",
			"hint"		=> "full|half|small, default: small. For small it doesnt support resource",			
		),
		array(
			"name"		=> "align",
			"hint"		=> "center|left|right, default: center",			
		),
		array(
			"name"		=> "color",
			"hint"		=> "#hexcode, default: skin color",			
		),
		array(
			"name"		=> "resource",
			"hint"		=> "none|text|icon|dots, default: none",			
		),

		array(
			"name"		=> "res_icon",
			"hint"		=> "icon_class, only for when resource is icon",			
		),

		array(
			"name"		=> "res_color",
			"hint"		=> "#hexcode, default: skin color",			
		),
		array(
			"name"		=> "res_bg",
			"hint"		=> "#hexcode, default: transparent",			
		),
		array(
			"name"		=> "margin_top",
			"hint"		=> "value in px",			
		),
		array(
			"name"		=> "margin_bottom",
			"hint"		=> "value in px",			
		),
		array(
			"name"		=> "class",
			"hint"		=> "custom css class to the wrapping element for future customization",			
		),

	);

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($data) {

		$this->loadTemplate();

		$vars		= $data["vars"];
		$css		= array();
		$style		= array();
		$style_res	= array();
		$style_line	= array();

		switch ($vars["width"]) {
			//defvult: $css[] = "divider-full-line";	break;
			case "half": $css[] = "divider-half-line";	break;
			case "small": $css[] = "divider-short-line";	break;
		}

		switch ($vars["style"]) {
			case "none":			$css[] = "divider-nolines"; break;	
			case "dashed":			$css[] = "divider-dashed";	break;
			case "dotted":			$css[] = "divider-dotted";	break;
			case "double_solid":	$css[] = "divider-double";	break;
			case "double_dashed":	$css[] = "divider-double divider-dashed";	break;
			case "double_dotted":	$css[] = "divider-double divider-dotted";	break;
		}

		switch ($vars["align"]) {
			default:		$css[] = "divider-center";	break;
			case "right":	$css[] = "divider-right";	break;
			case "left":	$css[] = "divider-left";	break;
		}

		switch ($vars["resource"]) {
			default: 

				if (!$vars["width"]) {
					$css[] = "divider-full-line";
				}
				
				$data = ""; 
			break;

			case "text": 
				$css[] = "divider-text";
				$data = $this->tpl->blockReplace("Text" , array("content" => $vars["content"])); 
			break;
			case "icon": 
				$css[] = "divider-resource";
				$data = $this->tpl->blockReplace("Icon" , array("icon" => $vars["res_icon"])); 
			break;
			case "dots": 
				$css[] = "divider-dots";
				$data = $this->tpl->blockReplace("Dots"); 
			break;
		}

//		debug($vars);


		if (!$val["color"]) {
		} else {
			$css[] = "divider-colored";
		}
		
		if ($vars["color"]) {
			$style_line[] = $this->getBackground($vars["color"] , "border-color")["bg_style"];
		}

		if ($vars["res_color"]) {
		
			if ($vars["resource"] =="dots") {
				$style_res[] = $this->getBackground($vars["res_color"] , "background")["bg_style"];
			} else {
				$style_res[] = $this->getBackground($vars["res_color"] , "color")["bg_style"];
			}
		}

		if ($vars["res_bg"] && ($vars["resource"] !="dots")) {
			$css[] = "divider-background";
			$style_res[] = $this->getBackground($vars["res_bg"] , "background")["bg_style"];
		}

		

		if ($vars["class"]) { $css[] = $vars["class"]; }




		return array(
			"content"	=> $this->tpl->blockReplace(
				"Main" , 
				array(
					"data"			=> $data,
					"css"			=> implode(" " , $css),
					"attr"			=> implode(" " , $attr),
				),
				array(
					"style"			=> implode(" " , $style),
					"style_res"		=> implode(" " , $style_res),
					"style_line"	=> implode(" " , $style_line),
				)				
			),
			"before"	=> "",
			"after"		=> "",
		);

	}
	
	
}